/** @file
  Metadata Helpers

  Copyright (c) 2025, Arm Limited. All rights reserved.
  SPDX-License-Identifier: BSD-2-Clause-Patent
**/

#ifndef METADATA_HELPER_H_
#define METADATA_HELPER_H_

#include <Library/MetadataHandlerLib.h>

/** Get the Root handle of the MetadataObjLib.

  During the firmware table generation, some Metadata information might be
  generated by different generators. This Metadata might be subject to
  additional validation.

  @return The Metadata Root handle.
**/
METADATA_ROOT_HANDLE
EFIAPI
GetMetadataRoot (
  VOID
  );

#endif // METADATA_HELPER_H_
