#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Mopi
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Disney 1994 games:
# - Aladdin
# - The Jungle Book
# - The Lion King
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250629.4

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID_ALADDIN='aladdin'
GAME_NAME_ALADDIN='Aladdin'

GAME_ID_JUNGLE='the-jungle-book'
GAME_NAME_JUNGLE='The Jungle Book'

GAME_ID_LION='the-lion-king'
GAME_NAME_LION='The Lion King'

## The following installers used to be sold by gog.com,
## but they have been retired in favour of a Windows-only collection.

ARCHIVE_BASE_ALADDIN_0_NAME='gog_disney_s_aladdin_2.0.0.2.sh'
ARCHIVE_BASE_ALADDIN_0_MD5='9dd6d84c2276809c5630320335e3415b'
ARCHIVE_BASE_ALADDIN_0_SIZE='18000'
ARCHIVE_BASE_ALADDIN_0_VERSION='1.0-gog2.0.0.2'

ARCHIVE_BASE_JUNGLE_0_NAME='gog_disney_s_the_jungle_book_2.0.0.2.sh'
ARCHIVE_BASE_JUNGLE_0_MD5='bcb57f4ff5cb1662ba3d4a9e34f263ad'
ARCHIVE_BASE_JUNGLE_0_SIZE='15000'
ARCHIVE_BASE_JUNGLE_0_VERSION='1.0-gog2.0.0.2'

ARCHIVE_BASE_LION_0_NAME='gog_the_lion_king_2.0.0.2.sh'
ARCHIVE_BASE_LION_0_MD5='3b4f1118785e1f1cc769ae41379b7940'
ARCHIVE_BASE_LION_0_SIZE='16000'
ARCHIVE_BASE_LION_0_VERSION='1.0-gog2.0.0.2'

CONTENT_PATH_DEFAULT='data/noarch/data'
CONTENT_GAME_MAIN_FILES_ALADDIN='
LEVEL.AMF
WNW.AMF
SOUND.CFG
BBC.CHR
ALADDIN.EXE
SETSND.EXE
*.DAT
*.FLR
*.JAM
*.OBT
*.PAC
*.RAW
*.RGB
*.SPE
*.XIS
*.XUN'
CONTENT_GAME_MAIN_FILES_JUNGLE='
JUNGLE.CFG
JUNGLE.EPF
INSTALL.EXE
JUNGLE.EXE
JUNGLEW.EXE'
CONTENT_GAME_MAIN_FILES_LION='
LIONKING.CFG
LIONKING.EPF
INSTALL.EXE
LIONKING.EXE'
CONTENT_DOC_MAIN_FILES='
README'
CONTENT_DOC0_MAIN_PATH='data/noarch/docs'
CONTENT_DOC0_MAIN_FILES='
Manual.pdf'

USER_PERSISTENT_FILES='
*.cfg'

APP_MAIN_EXE_ALADDIN='ALADDIN.EXE'
APP_MAIN_EXE_JUNGLE='JUNGLE.EXE'
APP_MAIN_EXE_LION='LIONKING.EXE'
APP_MAIN_ICON='../support/icon.png'
## Aladdin - Ensure good performances.
APP_MAIN_DOSBOX_PRERUN_ALADDIN='
config -set cpu cycles=max'
## The Lion King - Prevent a demo loop.
APP_MAIN_DOSBOX_PRERUN_LION='
config -set cpu cycles=fixed 15000'
## FIXME: The type of some DOS binaries is not correctly detected when using file 5.46.
##        (./play.it 2.32)
APP_MAIN_TYPE_JUNGLE='dosbox'
APP_MAIN_TYPE_LION='dosbox'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

## FIXME: APP_xxx_DOSBOX_PRERUN has no support for contextual values.
##        (./play.it 2.32)
APP_MAIN_DOSBOX_PRERUN=$(context_value 'APP_MAIN_DOSBOX_PRERUN')

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
