# Contributing

Thanks for your interest in Harlequin! Harlequin is primarily maintained by [Ted Conbeer](https://github.com/tconbeer), but he welcomes all contributions.

## Sponsoring Harlequin

Please consider [sponsoring Harlequin's author](https://github.com/sponsors/tconbeer), so he can continue to dedicate time to Harlequin.

## Providing Feedback

Ted would love to hear from you!

- [Create a New Discussion](https://github.com/tconbeer/harlequin/discussions/new/choose) to request new features, get troubleshooting support, or say hello.
- [Open an Issue](https://github.com/tconbeer/harlequin/issues/new?assignees=&labels=&projects=&template=bug_report.md&title=) to report bugs (Please use the bug template!).

## Contributing Documentation

Code for the [harlequin.sh](https://harlequin.sh/) website is hosted in the [`harlequin-web`](https://github.com/tconbeer/harlequin-web) repo. The docs are all written in Markdown, which makes them easy to update. Please open PRs against that repo if our docs can be improved.

## Contributing Code

We aim to create a welcoming and inclusive environment for new contributors, whether this is your first open-source contribution or your 1,000th. Please see the [Contributing Guide](https://harlequin.sh/docs/contributing/index) for detailed instructions on local development and testing, including an end-to-end walkthrough [video](https://www.tella.tv/video/cls3nmne700000gl4bcp91arr/view).

## Creating an Adapter

In addition to contributing to Harlequin core, you can contribute to one of Harlequin's many [adapters](https://harlequin.sh/docs/adapters), or create your own. There is a [guide to creating an adapter](https://harlequin.sh/docs/contributing/adapter-guide) on the Harlequin website.
