
// w20_1_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  1.500000
 // --table_div  1.604485
 // --table_op  0.012500

struct tablew20_1 { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tablew20_1_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tablew20_1&() const { return *(tablew20_1*)this; }
};

 static tablew20_1_imp<2048> w20_1_table __rt_data = {
	0,-0.833333,17.0583,2048, {
	0.000000000000,-0.023703513691,-0.043530065375,-0.060764735321,-0.076253119252,
	-0.090551762388,-0.104027099795,-0.116920529122,-0.129391208557,-0.141544204718,
	-0.153449005260,-0.165151694410,-0.176682960682,-0.188063363455,-0.199306796734,
	-0.210422767237,-0.221417892679,-0.232296887187,-0.243063209419,-0.253719488854,
	-0.264267806176,-0.274709877715,-0.285047176774,-0.295281013462,-0.305412587228,
	-0.315443021439,-0.325373386157,-0.335204713151,-0.344938005797,-0.354574245627,
	-0.364114396657,-0.373559408275,-0.382910217164,-0.392167748597,-0.401332917322,
	-0.410406628168,-0.419389776482,-0.428283248433,-0.437087921250,-0.445804663406,
	-0.454434334762,-0.462977786693,-0.471435862201,-0.479809396010,-0.488099214661,
	-0.496306136601,-0.504430972263,-0.512474524152,-0.520437586922,-0.528320947455,
	-0.536125384936,-0.543851670934,-0.551500569470,-0.559072837097,-0.566569222968,
	-0.573990468912,-0.581337309505,-0.588610472140,-0.595810677098,-0.602938637617,
	-0.609995059960,-0.616980643486,-0.623896080714,-0.630742057393,-0.637519252565,
	-0.644228338635,-0.650869981429,-0.657444840265,-0.663953568014,-0.670396811163,
	-0.676775209874,-0.683089398055,-0.689340003409,-0.695527647506,-0.701652945836,
	-0.707716507868,-0.713718937114,-0.719660831185,-0.725542781843,-0.731365375070,
	-0.737129191111,-0.742834804543,-0.748482784318,-0.754073693828,-0.759608090956,
	-0.765086528125,-0.770509552360,-0.775877705335,-0.781191523425,-0.786451537763,
	-0.791658274283,-0.796812253780,-0.801913991953,-0.806963999460,-0.811962781962,
	-0.816910840176,-0.821808669923,-0.826656762175,-0.831455603099,-0.836205674111,
	-0.840907451918,-0.845561408564,-0.850168011475,-0.854727723508,-0.859241002993,
	-0.863708303775,-0.868130075263,-0.872506762469,-0.876838806053,-0.881126642365,
	-0.885370703487,-0.889571417277,-0.893729207406,-0.897844493403,-0.901917690691,
	-0.905949210633,-0.909939460568,-0.913888843849,-0.917797759886,-0.921666604181,
	-0.925495768369,-0.929285640254,-0.933036603846,-0.936749039400,-0.940423323453,
	-0.944059828856,-0.947658924816,-0.951220976926,-0.954746347207,-0.958235394136,
	-0.961688472685,-0.965105934353,-0.968488127201,-0.971835395887,-0.975148081697,
	-0.978426522579,-0.981671053174,-0.984882004852,-0.988059705741,-0.991204480759,
	-0.994316651647,-0.997396536997,-1.000444452287,-1.003460709908,-1.006445619195,
	-1.009399486459,-1.012322615013,-1.015215305204,-1.018077854441,-1.020910557225,
	-1.023713705175,-1.026487587058,-1.029232488817,-1.031948693596,-1.034636481773,
	-1.037296130981,-1.039927916137,-1.042532109471,-1.045108980548,-1.047658796298,
	-1.050181821039,-1.052678316505,-1.055148541867,-1.057592753765,-1.060011206324,
	-1.062404151188,-1.064771837535,-1.067114512110,-1.069432419242,-1.071725800871,
	-1.073994896569,-1.076239943566,-1.078461176773,-1.080658828799,-1.082833129983,
	-1.084984308406,-1.087112589922,-1.089218198174,-1.091301354617,-1.093362278542,
	-1.095401187092,-1.097418295289,-1.099413816051,-1.101387960211,-1.103340936544,
	-1.105272951780,-1.107184210627,-1.109074915792,-1.110945267998,-1.112795466007,
	-1.114625706634,-1.116436184771,-1.118227093403,-1.119998623627,-1.121750964671,
	-1.123484303914,-1.125198826900,-1.126894717359,-1.128572157223,-1.130231326648,
	-1.131872404023,-1.133495565997,-1.135100987487,-1.136688841702,-1.138259300157,
	-1.139812532688,-1.141348707470,-1.142867991034,-1.144370548282,-1.145856542504,
	-1.147326135391,-1.148779487055,-1.150216756040,-1.151638099340,-1.153043672414,
	-1.154433629201,-1.155808122133,-1.157167302154,-1.158511318728,-1.159840319859,
	-1.161154452106,-1.162453860590,-1.163738689017,-1.165009079685,-1.166265173501,
	-1.167507109995,-1.168735027331,-1.169949062322,-1.171149350445,-1.172336025850,
	-1.173509221377,-1.174669068564,-1.175815697666,-1.176949237661,-1.178069816270,
	-1.179177559961,-1.180272593967,-1.181355042297,-1.182425027746,-1.183482671909,
	-1.184528095192,-1.185561416823,-1.186582754866,-1.187592226229,-1.188589946676,
	-1.189576030841,-1.190550592237,-1.191513743266,-1.192465595231,-1.193406258348,
	-1.194335841753,-1.195254453519,-1.196162200657,-1.197059189137,-1.197945523889,
	-1.198821308820,-1.199686646818,-1.200541639768,-1.201386388557,-1.202220993088,
	-1.203045552284,-1.203860164103,-1.204664925546,-1.205459932664,-1.206245280570,
	-1.207021063446,-1.207787374555,-1.208544306248,-1.209291949973,-1.210030396282,
	-1.210759734846,-1.211480054456,-1.212191443035,-1.212893987651,-1.213587774515,
	-1.214272888999,-1.214949415640,-1.215617438148,-1.216277039416,-1.216928301525,
	-1.217571305755,-1.218206132591,-1.218832861733,-1.219451572100,-1.220062341841,
	-1.220665248340,-1.221260368226,-1.221847777380,-1.222427550938,-1.222999763304,
	-1.223564488157,-1.224121798452,-1.224671766433,-1.225214463638,-1.225749960907,
	-1.226278328386,-1.226799635537,-1.227313951141,-1.227821343310,-1.228321879488,
	-1.228815626463,-1.229302650367,-1.229783016689,-1.230256790274,-1.230724035340,
	-1.231184815470,-1.231639193633,-1.232087232177,-1.232528992845,-1.232964536775,
	-1.233393924508,-1.233817215994,-1.234234470597,-1.234645747101,-1.235051103716,
	-1.235450598084,-1.235844287284,-1.236232227837,-1.236614475712,-1.236991086330,
	-1.237362114575,-1.237727614790,-1.238087640791,-1.238442245866,-1.238791482785,
	-1.239135403799,-1.239474060654,-1.239807504586,-1.240135786334,-1.240458956138,
	-1.240777063752,-1.241090158441,-1.241398288990,-1.241701503707,-1.241999850430,
	-1.242293376529,-1.242582128911,-1.242866154026,-1.243145497871,-1.243420205992,
	-1.243690323493,-1.243955895036,-1.244216964848,-1.244473576723,-1.244725774029,
	-1.244973599710,-1.245217096293,-1.245456305886,-1.245691270189,-1.245922030494,
	-1.246148627691,-1.246371102271,-1.246589494329,-1.246803843568,-1.247014189306,
	-1.247220570476,-1.247423025632,-1.247621592950,-1.247816310236,-1.248007214926,
	-1.248194344090,-1.248377734438,-1.248557422321,-1.248733443736,-1.248905834329,
	-1.249074629398,-1.249239863896,-1.249401572436,-1.249559789294,-1.249714548411,
	-1.249865883397,-1.250013827535,-1.250158413783,-1.250299674776,-1.250437642835,
	-1.250572349961,-1.250703827848,-1.250832107877,-1.250957221124,-1.251079198364,
	-1.251198070071,-1.251313866420,-1.251426617295,-1.251536352288,-1.251643100700,
	-1.251746891551,-1.251847753574,-1.251945715225,-1.252040804681,-1.252133049845,
	-1.252222478348,-1.252309117553,-1.252392994554,-1.252474136184,-1.252552569012,
	-1.252628319351,-1.252701413254,-1.252771876525,-1.252839734712,-1.252905013117,
	-1.252967736796,-1.253027930559,-1.253085618975,-1.253140826375,-1.253193576853,
	-1.253243894267,-1.253291802244,-1.253337324180,-1.253380483244,-1.253421302381,
	-1.253459804309,-1.253496011528,-1.253529946319,-1.253561630744,-1.253591086652,
	-1.253618335679,-1.253643399251,-1.253666298585,-1.253687054691,-1.253705688377,
	-1.253722220246,-1.253736670701,-1.253749059949,-1.253759407997,-1.253767734661,
	-1.253774059561,-1.253778402128,-1.253780781605,-1.253781217046,-1.253779727320,
	-1.253776331114,-1.253771046933,-1.253763893100,-1.253754887764,-1.253744048894,
	-1.253731394285,-1.253716941561,-1.253700708174,-1.253682711405,-1.253662968369,
	-1.253641496014,-1.253618311122,-1.253593430315,-1.253566870052,-1.253538646631,
	-1.253508776194,-1.253477274725,-1.253444158053,-1.253409441853,-1.253373141649,
	-1.253335272813,-1.253295850569,-1.253254889993,-1.253212406013,-1.253168413415,
	-1.253122926840,-1.253075960786,-1.253027529613,-1.252977647539,-1.252926328647,
	-1.252873586880,-1.252819436048,-1.252763889827,-1.252706961761,-1.252648665260,
	-1.252589013607,-1.252528019955,-1.252465697330,-1.252402058631,-1.252337116632,
	-1.252270883984,-1.252203373216,-1.252134596734,-1.252064566825,-1.251993295656,
	-1.251920795277,-1.251847077622,-1.251772154508,-1.251696037637,-1.251618738602,
	-1.251540268878,-1.251460639832,-1.251379862722,-1.251297948695,-1.251214908791,
	-1.251130753944,-1.251045494980,-1.250959142622,-1.250871707490,-1.250783200099,
	-1.250693630865,-1.250603010101,-1.250511348022,-1.250418654743,-1.250324940282,
	-1.250230214560,-1.250134487402,-1.250037768539,-1.249940067607,-1.249841394149,
	-1.249741757616,-1.249641167368,-1.249539632674,-1.249437162714,-1.249333766581,
	-1.249229453277,-1.249124231719,-1.249018110738,-1.248911099080,-1.248803205405,
	-1.248694438292,-1.248584806235,-1.248474317648,-1.248362980862,-1.248250804129,
	-1.248137795621,-1.248023963432,-1.247909315576,-1.247793859993,-1.247677604544,
	-1.247560557014,-1.247442725116,-1.247324116485,-1.247204738685,-1.247084599206,
	-1.246963705468,-1.246842064816,-1.246719684528,-1.246596571809,-1.246472733796,
	-1.246348177559,-1.246222910097,-1.246096938344,-1.245970269166,-1.245842909363,
	-1.245714865671,-1.245586144761,-1.245456753238,-1.245326697646,-1.245195984465,
	-1.245064620112,-1.244932610945,-1.244799963258,-1.244666683286,-1.244532777205,
	-1.244398251130,-1.244263111118,-1.244127363169,-1.243991013224,-1.243854067168,
	-1.243716530829,-1.243578409980,-1.243439710337,-1.243300437564,-1.243160597267,
	-1.243020195003,-1.242879236271,-1.242737726521,-1.242595671148,-1.242453075499,
	-1.242309944866,-1.242166284493,-1.242022099573,-1.241877395249,-1.241732176615,
	-1.241586448716,-1.241440216551,-1.241293485069,-1.241146259171,-1.240998543713,
	-1.240850343506,-1.240701663311,-1.240552507846,-1.240402881785,-1.240252789756,
	-1.240102236342,-1.239951226085,-1.239799763481,-1.239647852984,-1.239495499007,
	-1.239342705919,-1.239189478049,-1.239035819683,-1.238881735068,-1.238727228410,
	-1.238572303874,-1.238416965587,-1.238261217635,-1.238105064067,-1.237948508892,
	-1.237791556081,-1.237634209570,-1.237476473253,-1.237318350992,-1.237159846607,
	-1.237000963887,-1.236841706581,-1.236682078405,-1.236522083038,-1.236361724126,
	-1.236201005278,-1.236039930072,-1.235878502049,-1.235716724719,-1.235554601556,
	-1.235392136004,-1.235229331472,-1.235066191339,-1.234902718951,-1.234738917621,
	-1.234574790633,-1.234410341239,-1.234245572660,-1.234080488087,-1.233915090681,
	-1.233749383572,-1.233583369862,-1.233417052622,-1.233250434898,-1.233083519701,
	-1.232916310020,-1.232748808811,-1.232581019006,-1.232412943505,-1.232244585185,
	-1.232075946894,-1.231907031454,-1.231737841658,-1.231568380276,-1.231398650050,
	-1.231228653698,-1.231058393910,-1.230887873352,-1.230717094667,-1.230546060469,
	-1.230374773351,-1.230203235880,-1.230031450601,-1.229859420031,-1.229687146668,
	-1.229514632984,-1.229341881429,-1.229168894429,-1.228995674388,-1.228822223689,
	-1.228648544689,-1.228474639727,-1.228300511117,-1.228126161154,-1.227951592110,
	-1.227776806237,-1.227601805764,-1.227426592900,-1.227251169836,-1.227075538740,
	-1.226899701759,-1.226723661023,-1.226547418639,-1.226370976697,-1.226194337267,
	-1.226017502399,-1.225840474124,-1.225663254455,-1.225485845386,-1.225308248892,
	-1.225130466929,-1.224952501438,-1.224774354340,-1.224596027536,-1.224417522913,
	-1.224238842340,-1.224059987667,-1.223880960728,-1.223701763340,-1.223522397303,
	-1.223342864400,-1.223163166399,-1.222983305051,-1.222803282090,-1.222623099236,
	-1.222442758190,-1.222262260640,-1.222081608259,-1.221900802702,-1.221719845610,
	-1.221538738611,-1.221357483314,-1.221176081317,-1.220994534200,-1.220812843533,
	-1.220631010866,-1.220449037741,-1.220266925680,-1.220084676194,-1.219902290782,
	-1.219719770925,-1.219537118094,-1.219354333745,-1.219171419322,-1.218988376253,
	-1.218805205957,-1.218621909836,-1.218438489283,-1.218254945675,-1.218071280380,
	-1.217887494750,-1.217703590127,-1.217519567840,-1.217335429207,-1.217151175532,
	-1.216966808110,-1.216782328221,-1.216597737137,-1.216413036115,-1.216228226403,
	-1.216043309236,-1.215858285841,-1.215673157431,-1.215487925208,-1.215302590365,
	-1.215117154083,-1.214931617533,-1.214745981875,-1.214560248259,-1.214374417825,
	-1.214188491701,-1.214002471007,-1.213816356852,-1.213630150335,-1.213443852545,
	-1.213257464563,-1.213070987458,-1.212884422290,-1.212697770111,-1.212511031963,
	-1.212324208877,-1.212137301876,-1.211950311976,-1.211763240180,-1.211576087485,
	-1.211388854879,-1.211201543339,-1.211014153836,-1.210826687331,-1.210639144776,
	-1.210451527117,-1.210263835288,-1.210076070218,-1.209888232827,-1.209700324025,
	-1.209512344716,-1.209324295796,-1.209136178152,-1.208947992664,-1.208759740204,
	-1.208571421637,-1.208383037819,-1.208194589599,-1.208006077821,-1.207817503317,
	-1.207628866916,-1.207440169437,-1.207251411693,-1.207062594490,-1.206873718628,
	-1.206684784896,-1.206495794082,-1.206306746962,-1.206117644308,-1.205928486886,
	-1.205739275452,-1.205550010758,-1.205360693550,-1.205171324566,-1.204981904537,
	-1.204792434191,-1.204602914247,-1.204413345417,-1.204223728410,-1.204034063927,
	-1.203844352662,-1.203654595306,-1.203464792540,-1.203274945044,-1.203085053488,
	-1.202895118539,-1.202705140856,-1.202515121095,-1.202325059904,-1.202134957928,
	-1.201944815803,-1.201754634163,-1.201564413635,-1.201374154841,-1.201183858398,
	-1.200993524917,-1.200803155005,-1.200612749262,-1.200422308285,-1.200231832664,
	-1.200041322987,-1.199850779835,-1.199660203782,-1.199469595402,-1.199278955261,
	-1.199088283921,-1.198897581938,-1.198706849866,-1.198516088253,-1.198325297642,
	-1.198134478572,-1.197943631577,-1.197752757188,-1.197561855930,-1.197370928324,
	-1.197179974887,-1.196988996132,-1.196797992568,-1.196606964697,-1.196415913022,
	-1.196224838037,-1.196033740234,-1.195842620102,-1.195651478124,-1.195460314780,
	-1.195269130546,-1.195077925893,-1.194886701292,-1.194695457204,-1.194504194092,
	-1.194312912413,-1.194121612618,-1.193930295159,-1.193738960480,-1.193547609024,
	-1.193356241229,-1.193164857532,-1.192973458363,-1.192782044150,-1.192590615319,
	-1.192399172290,-1.192207715482,-1.192016245309,-1.191824762182,-1.191633266509,
	-1.191441758696,-1.191250239144,-1.191058708250,-1.190867166410,-1.190675614017,
	-1.190484051458,-1.190292479121,-1.190100897387,-1.189909306637,-1.189717707247,
	-1.189526099591,-1.189334484040,-1.189142860962,-1.188951230722,-1.188759593683,
	-1.188567950203,-1.188376300640,-1.188184645347,-1.187992984675,-1.187801318973,
	-1.187609648586,-1.187417973858,-1.187226295128,-1.187034612735,-1.186842927013,
	-1.186651238295,-1.186459546912,-1.186267853190,-1.186076157454,-1.185884460027,
	-1.185692761229,-1.185501061377,-1.185309360788,-1.185117659772,-1.184925958641,
	-1.184734257703,-1.184542557263,-1.184350857626,-1.184159159091,-1.183967461957,
	-1.183775766523,-1.183584073081,-1.183392381923,-1.183200693341,-1.183009007621,
	-1.182817325050,-1.182625645911,-1.182433970485,-1.182242299051,-1.182050631887,
	-1.181858969269,-1.181667311469,-1.181475658758,-1.181284011407,-1.181092369681,
	-1.180900733846,-1.180709104166,-1.180517480902,-1.180325864314,-1.180134254658,
	-1.179942652191,-1.179751057167,-1.179559469837,-1.179367890452,-1.179176319261,
	-1.178984756509,-1.178793202442,-1.178601657303,-1.178410121334,-1.178218594773,
	-1.178027077859,-1.177835570828,-1.177644073914,-1.177452587351,-1.177261111369,
	-1.177069646199,-1.176878192067,-1.176686749202,-1.176495317826,-1.176303898165,
	-1.176112490438,-1.175921094866,-1.175729711669,-1.175538341062,-1.175346983261,
	-1.175155638481,-1.174964306934,-1.174772988830,-1.174581684381,-1.174390393793,
	-1.174199117273,-1.174007855027,-1.173816607259,-1.173625374171,-1.173434155964,
	-1.173242952839,-1.173051764993,-1.172860592624,-1.172669435927,-1.172478295097,
	-1.172287170326,-1.172096061808,-1.171904969731,-1.171713894286,-1.171522835661,
	-1.171331794041,-1.171140769613,-1.170949762561,-1.170758773068,-1.170567801315,
	-1.170376847484,-1.170185911753,-1.169994994302,-1.169804095306,-1.169613214942,
	-1.169422353385,-1.169231510808,-1.169040687384,-1.168849883284,-1.168659098679,
	-1.168468333737,-1.168277588627,-1.168086863515,-1.167896158568,-1.167705473950,
	-1.167514809826,-1.167324166357,-1.167133543706,-1.166942942033,-1.166752361498,
	-1.166561802259,-1.166371264475,-1.166180748302,-1.165990253895,-1.165799781410,
	-1.165609330999,-1.165418902816,-1.165228497012,-1.165038113739,-1.164847753146,
	-1.164657415383,-1.164467100596,-1.164276808934,-1.164086540543,-1.163896295568,
	-1.163706074153,-1.163515876442,-1.163325702578,-1.163135552703,-1.162945426957,
	-1.162755325481,-1.162565248414,-1.162375195894,-1.162185168059,-1.161995165045,
	-1.161805186990,-1.161615234027,-1.161425306291,-1.161235403915,-1.161045527033,
	-1.160855675776,-1.160665850276,-1.160476050662,-1.160286277065,-1.160096529613,
	-1.159906808434,-1.159717113656,-1.159527445405,-1.159337803807,-1.159148188987,
	-1.158958601070,-1.158769040179,-1.158579506438,-1.158389999968,-1.158200520891,
	-1.158011069328,-1.157821645400,-1.157632249224,-1.157442880922,-1.157253540609,
	-1.157064228405,-1.156874944425,-1.156685688787,-1.156496461604,-1.156307262993,
	-1.156118093067,-1.155928951940,-1.155739839725,-1.155550756534,-1.155361702479,
	-1.155172677670,-1.154983682218,-1.154794716234,-1.154605779825,-1.154416873102,
	-1.154227996171,-1.154039149140,-1.153850332117,-1.153661545206,-1.153472788515,
	-1.153284062147,-1.153095366208,-1.152906700802,-1.152718066031,-1.152529461999,
	-1.152340888808,-1.152152346560,-1.151963835356,-1.151775355297,-1.151586906482,
	-1.151398489011,-1.151210102984,-1.151021748499,-1.150833425654,-1.150645134546,
	-1.150456875273,-1.150268647931,-1.150080452615,-1.149892289422,-1.149704158447,
	-1.149516059783,-1.149327993525,-1.149139959766,-1.148951958600,-1.148763990119,
	-1.148576054415,-1.148388151579,-1.148200281703,-1.148012444878,-1.147824641193,
	-1.147636870739,-1.147449133604,-1.147261429878,-1.147073759649,-1.146886123005,
	-1.146698520033,-1.146510950820,-1.146323415454,-1.146135914020,-1.145948446604,
	-1.145761013291,-1.145573614166,-1.145386249315,-1.145198918820,-1.145011622765,
	-1.144824361235,-1.144637134311,-1.144449942076,-1.144262784612,-1.144075662001,
	-1.143888574324,-1.143701521661,-1.143514504094,-1.143327521702,-1.143140574565,
	-1.142953662762,-1.142766786372,-1.142579945474,-1.142393140146,-1.142206370465,
	-1.142019636509,-1.141832938355,-1.141646275981,-1.141459649677,-1.141273059398,
	-1.141086505222,-1.140899987226,-1.140713505484,-1.140527060072,-1.140340651065,
	-1.140154278537,-1.139967942560,-1.139781643209,-1.139595380556,-1.139409154673,
	-1.139222965634,-1.139036813509,-1.138850698371,-1.138664620289,-1.138478579335,
	-1.138292575580,-1.138106609093,-1.137920679945,-1.137734788204,-1.137548933940,
	-1.137363117223,-1.137177338119,-1.136991596698,-1.136805893028,-1.136620227176,
	-1.136434599210,-1.136249009196,-1.136063457201,-1.135877943291,-1.135692467533,
	-1.135507029993,-1.135321630736,-1.135136269827,-1.134950947330,-1.134765663312,
	-1.134580417836,-1.134395210966,-1.134210042765,-1.134024913298,-1.133839822628,
	-1.133654770817,-1.133469757929,-1.133284784024,-1.133099849167,-1.132914953418,
	-1.132730096839,-1.132545279492,-1.132360501437,-1.132175762734,-1.131991063446,
	-1.131806403631,-1.131621783350,-1.131437202663,-1.131252661628,-1.131068160306,
	-1.130883698754,-1.130699277033,-1.130514895199,-1.130330553312,-1.130146251429,
	-1.129961989608,-1.129777767906,-1.129593586381,-1.129409445089,-1.129225344087,
	-1.129041283432,-1.128857263180,-1.128673283386,-1.128489344107,-1.128305445398,
	-1.128121587314,-1.127937769910,-1.127753993242,-1.127570257363,-1.127386562327,
	-1.127202908190,-1.127019295005,-1.126835722825,-1.126652191704,-1.126468701696,
	-1.126285252852,-1.126101845226,-1.125918478871,-1.125735153838,-1.125551870180,
	-1.125368627949,-1.125185427196,-1.125002267973,-1.124819150330,-1.124636074320,
	-1.124453039992,-1.124270047398,-1.124087096587,-1.123904187610,-1.123721320517,
	-1.123538495358,-1.123355712182,-1.123172971038,-1.122990271976,-1.122807615045,
	-1.122625000292,-1.122442427768,-1.122259897519,-1.122077409595,-1.121894964044,
	-1.121712560912,-1.121530200247,-1.121347882098,-1.121165606510,-1.120983373532,
	-1.120801183209,-1.120619035588,-1.120436930716,-1.120254868639,-1.120072849403,
	-1.119890873053,-1.119708939636,-1.119527049196,-1.119345201780,-1.119163397431,
	-1.118981636196,-1.118799918118,-1.118618243243,-1.118436611614,-1.118255023276,
	-1.118073478272,-1.117891976647,-1.117710518444,-1.117529103707,-1.117347732478,
	-1.117166404801,-1.116985120720,-1.116803880276,-1.116622683512,-1.116441530470,
	-1.116260421194,-1.116079355724,-1.115898334103,-1.115717356373,-1.115536422574,
	-1.115355532749,-1.115174686939,-1.114993885184,-1.114813127526,-1.114632414005,
	-1.114451744662,-1.114271119537,-1.114090538670,-1.113910002102,-1.113729509872,
	-1.113549062020,-1.113368658586,-1.113188299608,-1.113007985127,-1.112827715182,
	-1.112647489811,-1.112467309053,-1.112287172946,-1.112107081530,-1.111927034842,
	-1.111747032921,-1.111567075805,-1.111387163531,-1.111207296137,-1.111027473661,
	-1.110847696140,-1.110667963611,-1.110488276112,-1.110308633679,-1.110129036349,
	-1.109949484158,-1.109769977144,-1.109590515342,-1.109411098790,-1.109231727521,
	-1.109052401574,-1.108873120983,-1.108693885783,-1.108514696012,-1.108335551702,
	-1.108156452891,-1.107977399613,-1.107798391902,-1.107619429794,-1.107440513323,
	-1.107261642524,-1.107082817430,-1.106904038076,-1.106725304497,-1.106546616725,
	-1.106367974795,-1.106189378740,-1.106010828594,-1.105832324390,-1.105653866162,
	-1.105475453941,-1.105297087762,-1.105118767657,-1.104940493659,-1.104762265799,
	-1.104584084112,-1.104405948628,-1.104227859380,-1.104049816400,-1.103871819719,
	-1.103693869370,-1.103515965385,-1.103338107793,-1.103160296627,-1.102982531919,
	-1.102804813698,-1.102627141997,-1.102449516845,-1.102271938273,-1.102094406313,
	-1.101916920994,-1.101739482346,-1.101562090400,-1.101384745187,-1.101207446735,
	-1.101030195074,-1.100852990234,-1.100675832246,-1.100498721137,-1.100321656937,
	-1.100144639676,-1.099967669383,-1.099790746086,-1.099613869814,-1.099437040596,
	-1.099260258460,-1.099083523436,-1.098906835550,-1.098730194831,-1.098553601308,
	-1.098377055007,-1.098200555958,-1.098024104188,-1.097847699723,-1.097671342593,
	-1.097495032823,-1.097318770441,-1.097142555475,-1.096966387951,-1.096790267896,
	-1.096614195337,-1.096438170300,-1.096262192812,-1.096086262900,-1.095910380589,
	-1.095734545905,-1.095558758876,-1.095383019526,-1.095207327881,-1.095031683968,
	-1.094856087811,-1.094680539437,-1.094505038870,-1.094329586136,-1.094154181260,
	-1.093978824266,-1.093803515180,-1.093628254027,-1.093453040831,-1.093277875616,
	-1.093102758408,-1.092927689231,-1.092752668108,-1.092577695064,-1.092402770122,
	-1.092227893308,-1.092053064644,-1.091878284154,-1.091703551862,-1.091528867791,
	-1.091354231965,-1.091179644406,-1.091005105139,-1.090830614185,-1.090656171568,
	-1.090481777311,-1.090307431436,-1.090133133965,-1.089958884923,-1.089784684330,
	-1.089610532209,-1.089436428582,-1.089262373471,-1.089088366899,-1.088914408887,
	-1.088740499456,-1.088566638629,-1.088392826427,-1.088219062871,-1.088045347983,
	-1.087871681784,-1.087698064295,-1.087524495537,-1.087350975530,-1.087177504297,
	-1.087004081857,-1.086830708231,-1.086657383440,-1.086484107504,-1.086310880443,
	-1.086137702277,-1.085964573027,-1.085791492712,-1.085618461353,-1.085445478970,
	-1.085272545580,-1.085099661206,-1.084926825866,-1.084754039579,-1.084581302364,
	-1.084408614242,-1.084235975230,-1.084063385348,-1.083890844615,-1.083718353050,
	-1.083545910671,-1.083373517498,-1.083201173547,-1.083028878839,-1.082856633390,
	-1.082684437220,-1.082512290346,-1.082340192787,-1.082168144560,-1.081996145684,
	-1.081824196175,-1.081652296052,-1.081480445332,-1.081308644033,-1.081136892172,
	-1.080965189765,-1.080793536831,-1.080621933387,-1.080450379448,-1.080278875033,
	-1.080107420158,-1.079936014839,-1.079764659094,-1.079593352938,-1.079422096388,
	-1.079250889461,-1.079079732173,-1.078908624539,-1.078737566576,-1.078566558299,
	-1.078395599726,-1.078224690870,-1.078053831748,-1.077883022376,-1.077712262769,
	-1.077541552942,-1.077370892911,-1.077200282690,-1.077029722296,-1.076859211742,
	-1.076688751044,-1.076518340217,-1.076347979276,-1.076177668234,-1.076007407107,
	-1.075837195909,-1.075667034655,-1.075496923358,-1.075326862033,-1.075156850695,
	-1.074986889357,-1.074816978032,-1.074647116735,-1.074477305481,-1.074307544281,
	-1.074137833150,-1.073968172102,-1.073798561149,-1.073629000306,-1.073459489584,
	-1.073290028998,-1.073120618561,-1.072951258285,-1.072781948183,-1.072612688269,
	-1.072443478554,-1.072274319052,-1.072105209774,-1.071936150734,-1.071767141944,
	-1.071598183416,-1.071429275161,-1.071260417193,-1.071091609524,-1.070922852164,
	-1.070754145127,-1.070585488423,-1.070416882065,-1.070248326064,-1.070079820431,
	-1.069911365179,-1.069742960317,-1.069574605858,-1.069406301813,-1.069238048192,
	-1.069069845007,-1.068901692269,-1.068733589988,-1.068565538176,-1.068397536842,
	-1.068229585998,-1.068061685653,-1.067893835819,-1.067726036505,-1.067558287722,
	-1.067390589480,-1.067222941790,-1.067055344660,-1.066887798101,-1.066720302123,
	-1.066552856735,-1.066385461948,-1.066218117771,-1.066050824212,-1.065883581282,
	-1.065716388991,-1.065549247346,-1.065382156358,-1.065215116035,-1.065048126387,
	-1.064881187422,-1.064714299149,-1.064547461578,-1.064380674716,-1.064213938572,
	-1.064047253155,-1.063880618474,-1.063714034536,-1.063547501350,-1.063381018924,
	-1.063214587266,-1.063048206384,-1.062881876287,-1.062715596981,-1.062549368476,
	-1.062383190778,-1.062217063895,-1.062050987835,-1.061884962605,-1.061718988213,
	-1.061553064666,-1.061387191972,-1.061221370136,-1.061055599168,-1.060889879072,
	-1.060724209857,-1.060558591530,-1.060393024096,-1.060227507564,-1.060062041938,
	-1.059896627227,-1.059731263436,-1.059565950572,-1.059400688641,-1.059235477649,
	-1.059070317603,-1.058905208508,-1.058740150371,-1.058575143197,-1.058410186993,
	-1.058245281764,-1.058080427516,-1.057915624254,-1.057750871984,-1.057586170711,
	-1.057421520442,-1.057256921180,-1.057092372932,-1.056927875702,-1.056763429496,
	-1.056599034319,-1.056434690175,-1.056270397070,-1.056106155007,-1.055941963993,
	-1.055777824031,-1.055613735127,-1.055449697284,-1.055285710507,-1.055121774800,
	-1.054957890168,-1.054794056615,-1.054630274144,-1.054466542761,-1.054302862468,
	-1.054139233270,-1.053975655171,-1.053812128174,-1.053648652283,-1.053485227501,
	-1.053321853833,-1.053158531281,-1.052995259849,-1.052832039540,-1.052668870357,
	-1.052505752305,-1.052342685384,-1.052179669600,-1.052016704954,-1.051853791449,
	-1.051690929088,-1.051528117875,-1.051365357811,-1.051202648899,-1.051039991142,
	-1.050877384541,-1.050714829100,-1.050552324821,-1.050389871705,-1.050227469756,
	-1.050065118975,-1.049902819363,-1.049740570924,-1.049578373658,-1.049416227567,
	-1.049254132654,-1.049092088920,-1.048930096366,-1.048768154995,-1.048606264806,
	-1.048444425802,-1.048282637984,-1.048120901354,-1.047959215911,-1.047797581658,
	-1.047635998595,-1.047474466723,-1.047312986043,-1.047151556557,-1.046990178263,
	-1.046828851164,-1.046667575260,-1.046506350550,-1.046345177037,-1.046184054719,
	-1.046022983598,-1.045861963673,-1.045700994945,-1.045540077414,-1.045379211079,
	-1.045218395941,-1.045057631999,-1.044896919254,-1.044736257705,-1.044575647351,
	-1.044415088193,-1.044254580229,-1.044094123460,-1.043933717884,-1.043773363502,
	-1.043613060311,-1.043452808312,-1.043292607503,-1.043132457883,-1.042972359452,
	-1.042812312209,-1.042652316151,-1.042492371278,-1.042332477589,-1.042172635082,
	-1.042012843756,-1.041853103610,-1.041693414641,-1.041533776847,-1.041374190229,
	-1.041214654782,-1.041055170507,-1.040895737400,-1.040736355460,-1.040577024684,
	-1.040417745072,-1.040258516619,-1.040099339325,-1.039940213186,-1.039781138201,
	-1.039622114367,-1.039463141681,-1.039304220141,-1.039145349744,-1.038986530488,
	-1.038827762369,-1.038669045385,-1.038510379533,-1.038351764809,-1.038193201212,
	-1.038034688737,-1.037876227381,-1.037717817142,-1.037559458015,-1.037401149998,
	-1.037242893087,-1.037084687278,-1.036926532568,-1.036768428954,-1.036610376431,
	-1.036452374995,-1.036294424644,-1.036136525372,-1.035978677176,-1.035820880052,
	-1.035663133996,-1.035505439003,-1.035347795069,-1.035190202191,-1.035032660363,
	-1.034875169581,-1.034717729841,-1.034560341138,-1.034403003467,-1.034245716824,
	-1.034088481204,-1.033931296602,-1.033774163013,-1.033617080432,-1.033460048854,
	-1.033303068275,-1.033146138688,-1.032989260089,-1.032832432472,-1.032675655832,
	-1.032518930164,-1.032362255462,-1.032205631721,-1.032049058934,-1.031892537097,
	-1.031736066203,-1.031579646246,-1.031423277222,-1.031266959123,-1.031110691945,
	-1.030954475680,-1.030798310322,-1.030642195867,-1.030486132306,-1.030330119635,
	-1.030174157845,-1.030018246932,-1.029862386889,-1.029706577708,-1.029550819384,
	-1.029395111909,-1.029239455277,-1.029083849482,-1.028928294515,-1.028772790371,
	-1.028617337041,-1.028461934520,-1.028306582800,-1.028151281873,-1.027996031733,
	-1.027840832372,-1.027685683783,-1.027530585958,-1.027375538890,-1.027220542570,
	-1.027065596993,-1.026910702149,-1.026755858031,-1.026601064631,-1.026446321942,
	-1.026291629955,-1.026136988662,-1.025982398056,-1.025827858127,-1.025673368868,
	-1.025518930271,-1.025364542327,-1.025210205028,-1.025055918365,-1.024901682330,
	-1.024747496914,-1.024593362109,-1.024439277906,-1.024285244296,-1.024131261270,
	-1.023977328820,-1.023823446936,-1.023669615610,-1.023515834831,-1.023362104593,
	-1.023208424884,-1.023054795695,-1.022901217019,-1.022747688844,-1.022594211162,
	-1.022440783963,-1.022287407237,-1.022134080975,-1.021980805168,-1.021827579805,
	-1.021674404876,-1.021521280373,-1.021368206283,-1.021215182599,-1.021062209310,
	-1.020909286404,-1.020756413874,-1.020603591708,-1.020450819895,-1.020298098426,
	-1.020145427290,-1.019992806477,-1.019840235976,-1.019687715776,-1.019535245867,
	-1.019382826238,-1.019230456878,-1.019078137776,-1.018925868922,-1.018773650305,
	-1.018621481913,-1.018469363735,-1.018317295761,-1.018165277978,-1.018013310377,
	-1.017861392945,-1.017709525671,-1.017557708543,-1.017405941550,-1.017254224681,
	-1.017102557924,-1.016950941267,-1.016799374698,-1.016647858206,-1.016496391779,
	-1.016344975404,-1.016193609070,-1.016042292765,-1.015891026476,-1.015610935361,
	-1.015071737894,-1.014442208851,-1.013763928034,-1.013053389577,-1.012318201184,
	-1.011562184001,-1.010787439815,-1.009995276601,-1.009186639778,-1.008362314098,
	-1.007523015713,-1.006669431337,-1.005802232412,-1.004922078049,-1.004029613484,
	-1.003125467227,-1.002210248326,-1.001284544264,-1.000348919599,-0.999403915297,
	-0.998450048615,-0.997487813410,-0.996517680742,-0.995540099682,-0.994555498236,
	-0.993564284341,-0.992566846875,-0.991563556676,-0.990554767520,-0.989540817072,
	-0.988522027788,-0.987498707770,-0.986471151569,-0.985439640939,-0.984404445543,
	-0.983365823616,-0.982324022574,-0.981279279594,-0.980231822149,-0.979181868507,
	-0.978129628200,-0.977075302460,-0.976019084628,-0.974961160533,-0.973901708856,
	-0.972840901458,-0.971778903702,-0.970715874742,-0.969651967807,-0.968587330458,
	-0.967522104836,-0.966456427894,-0.965390431618,-0.964324243229,-0.963257985385,
	-0.962191776363,-0.961125730233,-0.960059957026,-0.958994562891,-0.957929650247,
	-0.956865317921,-0.955801661285,-0.954738772387,-0.953676740068,-0.952615650086,
	-0.951555585220,-0.950496625381,-0.949438847710,-0.948382326678,-0.947327134177,
	-0.946273339607,-0.945221009963,-0.944170209914,-0.943121001885,-0.942073446124,
	-0.941027600781,-0.939983521971,-0.938941263844,-0.937900878643,-0.936862416770,
	-0.935825926842,-0.934791455748,-0.933759048698,-0.932728749284,-0.931700599523,
	-0.930674639906,-0.929650909449,-0.928629445730,-0.927610284940,-0.926593461921,
	-0.925579010205,-0.924566962054,-0.923557348500,-0.922550199376,-0.921545543355,
	-0.920543407983,-0.919543819711,-0.918546803925,-0.917552384980,-0.916560586228,
	-0.915571430047,-0.914584937865,-0.913601130194,-0.912620026650,-0.911641645980,
	-0.910666006087,-0.909693124053,-0.908723016162,-0.907755697922,-0.906791184089,
	-0.905829488684,-0.904870625014,-0.903914605696,-0.902961442669,-0.902011147220,
	-0.901063729996,-0.900119201026,-0.899177569735,-0.898238844960,-0.897303034971,
	-0.896370147479,-0.895440189660,-0.894513168161,-0.893589089120,-0.892667958179,
	-0.891749780496,-0.890834560759,-0.889922303199,-0.889013011603,-0.888106689325,
	-0.887203339297,-0.886302964045,-0.885405565695,-0.884511145985,-0.883619706278,
	-0.882731247572,-0.881845770505,-0.880963275374,-0.880083762135,-0.879207230418,
	-0.878333679537,-0.877463108492,-0.876595515985,-0.875730900427,-0.874869259940,
	-0.874010592374,-0.873154895309,-0.872302166063,-0.871452401702,-0.870605599044,
	-0.869761754669,-0.868920864923,-0.868082925928,-0.867247933585,-0.866415883582,
	-0.865586771401,-0.864760592323,-0.863937341434,-0.863117013631,-0.862299603627,
	-0.861485105957,-0.860673514984,-0.859864824903,-0.859059029746,-0.858256123389,
	-0.857456099553,-0.856658951814,-0.855864673601,-0.855073258209,-0.854284698795,
	-0.853498988387,-0.852716119886,-0.851936086073,-0.851158879611,-0.850384493046,
	-0.849612918819,-0.848844149260,-0.848078176598,-0.847314992963,-0.846554590388,
	-0.845796960816,-0.845042096097,-0.844289987998,-0.843540628202,-0.842794008312,
	-0.842050119857,-0.841308954287,-0.840570502985,-0.839834757265,-0.839101708375,
	-0.838371347500,-0.837643665764,-0.836918654236,-0.836196303926,-0.835476605794,
	-0.834759550748,-0.834045129650,-0.833333333312
	}
};

double always_inline w20_1clip(double x) {
    double f = fabs(x);
    f = f * w20_1_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = w20_1_table.data[0];
    } else if (i >= w20_1_table.size-1) {
        f = w20_1_table.data[w20_1_table.size-1];
    } else {
    f -= i;
    f = w20_1_table.data[i]*(1-f) + w20_1_table.data[i+1]*f;
    }
    return copysign(f, x);
}

